// gcc -o mmencode.exe mmencode.c
#include <stdio.h>

int main(int argc, char* argv[]){
	FILE *fp;
	unsigned long sz;
	unsigned long pos=0;
	int d[4];
	int i;
	if(argc<2){
		printf("FILE CONVERTER for MMBASIC\n");
		printf("eg: sample in.wav\n");
		printf("Output to console\n");
		printf("(C) 2020 Silicon Chip Publications\n");
		return 0;
	}
	fp=fopen(argv[1], "rb");
	if(!fp){		//file error
		printf("Input file error on '%s'\r\n",argv[1]);		
		fclose(fp);
		return -1;		
	}	
	//process data here
	fseek(fp, 0L, SEEK_END);
	sz = ftell(fp);	
	fseek(fp, 0L, SEEK_SET);
	//file info in a comment
	printf("'%s' is %u bytes long.\n",argv[1],sz);	
	//header
	printf("CFUNCTION %s AS INTEGER\n 00000000\n %0.8lX",argv[1],sz);	
	while(pos<sz){
		//do this the hard way so it will work on either endian system
		if(((pos)&0x1f)==0){	//end of line
			printf("\n ");
		}else{
			printf(" ");
		}		
		for(i=0;i<4;i++){
			d[i]=0;						//load empty
			fread(d+i,1,1,fp);	    	//read
			d[i]=d[i]&0xFF;
			pos++;
		}
		for(i=3;i>=0;i--){		//and reverse to get LSB at right and always output 32 bits
			printf("%0.2lX",d[i]);
		}
	}
	printf("\r\nEND CFUNCTION\n");
	printf("'OK %u bytes written.\n",pos);
	fclose(fp);
	return 0;
}
